% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PTwrap.R
\encoding{UTF8}
\name{PTwrap}
\alias{PTwrap}
\title{Wrapper to ProtectTable() with additional methods (partly experimental)}
\usage{
PTwrap(
  ...,
  maxN = 3,
  method = "SimpleSingle",
  exeArgus = "C:/Tau/TauArgus.exe",
  pathArgus = getwd(),
  solverArgus = "FREE",
  methodArgus = "OPT",
  rgArgus = 0
)
}
\arguments{
\item{...}{Parameters to ProtectTable}

\item{maxN}{Parameter to ProtectTable}

\item{method}{Parameter to ProtectTable or a wrapper method (see details)}

\item{exeArgus}{Parameter to \code{\link[sdcTable]{runArgusBatchFile}}}

\item{pathArgus}{Parameter to \code{\link[sdcTable]{createArgusInput}}}

\item{solverArgus}{Parameter "solver" to \code{\link[sdcTable]{createArgusInput}}}

\item{methodArgus}{Parameter "method" to \code{\link[sdcTable]{createArgusInput}}}

\item{rgArgus}{Parameter "rg" in "primSuppRules" in \code{\link[sdcTable]{createArgusInput}}}
}
\value{
See \code{\link{ProtectTable}}
}
\description{
Additional values of "method" is possible. Each new method (wrapper method) will make a call 
 to ProtectTable() using a specific parameter setting.
}
\details{
The wrapper methods are:

 \strong{Simple:}  "SIMPLEHEURISTIC" with detectSingletons=FALSE
 
 \strong{SimpleSingle:} "SIMPLEHEURISTIC" with detectSingletons=TRUE when protectZeros=FALSE and
                           "SIMPLEHEURISTIC" with threshold=1 (can be overridden by input) when protectZeros=TRUE 
 
 \strong{SimpleSingleOld:} "SIMPLEHEURISTIC" with detectSingletons=TRUE
 
 \strong{TauArgus:} Tau-argus will be run according to the settings of the other input parameters.
 
 Using \code{rgArgus=0} is equivalent to calling ProtectTable() with \cr 
 \code{method = list(exe=exeArgus, typ="tabular", path=pathArgus,} \cr
 \code{solver=solverArgus, method=methodArgus)))}
 
 Other values of \code{rgArgus} is equivalent to calling ProtectTable() with \cr
 \code{method = list(exe=exeArgus, typ="microdata", path=pathArgus,}\cr 
 \code{solver=solverArgus, method=methodArgus,}\cr
 \code{primSuppRules=list(list(type="freq", n=maxN+1, rg=rgArgus )))))}
 
 \strong{TauArgusOPT:} As "TauArgus" with \code{methodArgus="OPT"}
 
 \strong{TauArgusMOD:} As "TauArgus" with \code{methodArgus="MOD"}
 
 \strong{TauArgusGH:}  As "TauArgus" with \code{methodArgus="GH"}
}
