% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_R.R
\name{get_R}
\alias{get_R}
\alias{get_R.default}
\alias{get_R.integer}
\alias{get_R.numeric}
\alias{get_R.incidence}
\title{Estimate the Reproduction Number}
\usage{
get_R(x, ...)

\method{get_R}{default}(x, ...)

\method{get_R}{integer}(
  x,
  disease = NULL,
  si = NULL,
  si_mean = NULL,
  si_sd = NULL,
  max_R = 10,
  days = 30,
  ...
)

\method{get_R}{numeric}(x, ...)

\method{get_R}{incidence}(x, ...)
}
\arguments{
\item{x}{The daily incidence to be used for inferring the reproduction
number. Input can be an \code{incidence} object, as output by the package
\code{incidence}, or a vector of numbers indicating daily number of
cases. Note that 'zero' incidence should be reported as well (see
details).}

\item{...}{Further arguments to be passed to the methods.}

\item{disease}{A character string indicating the name of the disease
studied. If provided, then \code{si_mean} and \code{si_sd} will be filled
in automatically using value from the literature. Accepted values are:
"ebola".}

\item{si}{A \code{distcrete} object (see package \code{distcrete}) containing
the discretized distribution of the serial interval.}

\item{si_mean}{The mean of the serial interval distribution. Ignored if
\code{si} is provided.}

\item{si_sd}{The standard deviation of the serial interval
distribution. Ignored if \code{si} is provided.}

\item{max_R}{The maximum value the reproduction number can take.}

\item{days}{The number of days after the last incidence date for which the
force of infection should be computed. This does not change the
estimation of the reproduction number, but will affect projections.}
}
\value{
A list with the \code{earlyR} class, containing the following
    components:
\itemize{
\item \code{$incidence}: the input incidence, in its original format

\item \code{$R_grid}: the grid of R values for which the likelihood has been
computed.

\item \code{$R_like}: the values of likelihood corresponding to the
\code{$R_grid}

\item \code{$R_ml}: the maximum likelihood estimate of R

\item \code{$dates}: the dates for which infectiousness has been computed

\item \code{$lambdas}: the corresponding values of force of infection

\item \code{$si}: the serial interval, stored as a \code{distcrete} object

}
}
\description{
This function estimates the (most of the time, 'basic') reproduction number
(R) using i) the known distribution of the Serial Interval (delay between
primary to secondary onset) and ii) incidence data.
}
\details{
The estimation of R relies on all available incidence data. As such,
    all zero incidence after the first case should be included in
    \code{x}. When using \code{inidence} from the 'incidence' package, make
    sure you use the argument \code{last_date} to indicate where the epicurve
    stops, otherwise the curve is stopped after the last case. Use
    \code{as.data.frame} to double-check that the epicurve includes the last
    'zeros'.
}
\examples{

if (require(incidence)) {

## example: onsets on days 1, 5, 6 and 12; estimation on day 24
 x <- incidence(c(1, 5, 6, 12), last_date = 24)
 x
 as.data.frame(x)
 plot(x)
 res <- get_R(x, disease = "ebola")
 res
 plot(res)

}

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
