% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehension.R
\name{..}
\alias{..}
\title{Create Vector}
\usage{
..(..., clust = NULL, type = Vec, simplify = TRUE)
}
\arguments{
\item{...}{values to be combined within a vector. Arguments beginning with \code{for} are interpreted as comprehensions.}

\item{clust}{cluster to use for \code{\link[parallel:clusterApply]{parallel}} computations}

\item{type}{\code{\link{comprehension}} function used when \code{for} arguments are present. Defaults to \code{Vec}.}

\item{simplify}{logical; should the result be simplified to an array if possible?}
}
\value{
vector
}
\description{
The \code{..} function allows for the quick creation of vector using either
\code{..(...)} or \code{..[...]}. It accepts vector \code{\link{comprehension}}
arguments using \code{for ...}. It can also be used as a more general form of
\code{\link[base:c]{c}}.
}
\examples{
..[for (i in 1:10) 2*(1:i)]

}
