% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spreader.R
\name{spreader}
\alias{spreader}
\title{Temporal downscaling of entomological surveillance observations}
\usage{
spreader(
  mydf = NULL,
  date.field = NULL,
  value.field = NULL,
  counter.field = NULL,
  seed = 123
)
}
\arguments{
\item{mydf}{A data.frame.}

\item{date.field}{character, name of field containing dates.}

\item{value.field}{integer, name of field containing the number of individuals sampled.}

\item{counter.field}{integer, name of the field containing the number of days/weeks between each sampling.
This is optional, if NULL then the function will compute the value assuming the trap was active during the whole
period between two consecutive samplings.}

\item{seed}{integer, define the seed for the binomial draws, default \code{seed = 123}.}
}
\value{
Returns a data.frame with the "adjusted value", i.e. the observation spread over the period of activity of the trap
}
\description{
Temporal downscaling of entomological surveillance observations
}
\author{
Daniele Da Re \email{dare.daniele@gmail.com}, Giovanni Marini \email{dare.daniele@gmail.com}
}
