% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subject_level_flag.R
\name{subject_level_flag}
\alias{subject_level_flag}
\title{Create Subject-level Flag from Long Data}
\usage{
subject_level_flag(data, data_long, ..., .key = "USUBJID")
}
\arguments{
\item{data}{(\code{data.frame})\cr
a subject-level data frame, e.g. \code{adsl}}

\item{data_long}{(\code{data.frame})\cr
a long data frame that is more than one line per subject, e.g. \code{adae}.
The expressions passed in \code{...} will be evaluated in this data frame.}

\item{...}{(\code{\link[rlang:args_data_masking]{data-masking}})\cr
Name and condition pairs. The name is the name of the new subject-level
flag column. The condition is an expression that results in a logical vector.
These name-condition pairs are passed directly to \code{dplyr::mutate(...)}.}

\item{.key}{(\code{character})\cr
Key columns create flags within and to merge by.
Default is \code{'USUBJID'}}
}
\value{
Subject-level data frame
}
\description{
Utility for creating subject-level flags from data frames that are
more than one line per subject.
For example, use this function to create a flag indicating whether a
subject experienced any serious adverse events.

The function works by first creating a logical variable in \code{data_long}
indicating whether the condition passed in the \code{...} argument is met.
If a subject has true on any row, then the new variable is added
to \code{data} as \code{TRUE}, otherwise that subject's value is populated with a \code{FALSE}.
}
\examples{
adsl <- tibble::tribble(
  ~USUBJID,      ~SEX,
  "01-701-1015", "F",
  "01-701-1023", "M",
  "01-701-1028", "M"
)

adae <- tibble::tribble(
  ~USUBJID,      ~AESER, ~AEACN,
  "01-701-1015", "Y",    "DOSE NOT CHANGED",
  "01-701-1015", "N",    "DOSE NOT CHANGED",
  "01-701-1028", "N",    "DRUG WITHDRAWN"
)

subject_level_flag(
  data = adsl,
  data_long = adae,
  ANY_AESER = AESER == "Y",
  ANY_DRUG_WITHDRAWN = AEACN == "DRUG WITHDRAWN"
)
}
