#' @title Goverment services and facilities
#'
#' @description A data set collected in Nishisato's scaling class (1982) in
#' which 31 students on 10 municipal services in Toronto.
#'
#' @format A subset of the original data of 10 subjects on 10 municipal
#' services in Toronto:
#' \describe{
#'  \item{\code{A}}{Public transit system}
#'  \item{\code{B}}{Postal service}
#'  \item{\code{C}}{Medical care, including hospitals and clinics}
#'  \item{\code{D}}{Sports, recreational facilities}
#'  \item{\code{E}}{Police protection}
#'  \item{\code{F}}{public libraries}
#'  \item{\code{G}}{cleaning streets}
#'  \item{\code{H}}{restaurants}
#'  \item{\code{I}}{theatres}
#'  \item{\code{J}}{Overall planning and development}
#'  }
#'
#' @details The data were originally collected to ranked the "most
#' satisfactory" service, the "second most satisfactory", and so on until
#' the "least satisfactory".
#'
#' @source Nishisato, S. and Nishisato, I.(1994). \emph{Dual Scaling in a
#' Nutshell}. Toronto: MicroStats.
#'
#' @references Nishisato, S. and Nishisato, I.(1994). \emph{Dual Scaling in a
#' Nutshell}. Toronto: MicroStats.
#'
#' @usage goverment
#'
#' @keywords datasets
"goverment"
