% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_simplify.R
\name{dtms_simplify}
\alias{dtms_simplify}
\title{Simplify state names}
\usage{
dtms_simplify(probs, fromvar = "from", tovar = "to", sep = "_")
}
\arguments{
\item{probs}{Object with transition probabilities as created with \code{dtms_transitions}.}

\item{fromvar}{Character (optional), name of variable in `probs` with starting state. Default is `from`.}

\item{tovar}{Character (optional), name of variable in `probs` with receiving state. Default is `to`.}

\item{sep}{Character (optional), separator between short state name and value of time scale. Default is `_`.}
}
\value{
Data frame
}
\description{
This function turns long state names into short state names. It is
particularly useful for plotting and when used in pipes, see the example.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Fit model
fit <- dtms_fit(data=estdata)
## Predict probabilities
probs    <- dtms_transitions(dtms=simple,
                             model = fit)
## Simplify
probs |>  dtms_simplify()
## NOT RUN: requires ggplot2
# library(ggplot2)
# probs |>  dtms_simplify() |>
#   ggplot(aes(x=time,y=P,color=to)) +
#   geom_line() +
#   facet_wrap(~from)
}
