% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_rewardmatrix.R
\name{dtms_rewardmatrix}
\alias{dtms_rewardmatrix}
\title{Generate the reward matrix for a Markov chain with rewards}
\usage{
dtms_rewardmatrix(
  dtms,
  starting = NULL,
  receiving,
  reward,
  start_time = NULL,
  end_time = NULL
)
}
\arguments{
\item{dtms}{dtms object, as created with \code{dtms}.}

\item{starting}{Character (optional), name or names of starting states. If NULL (default) any transition to the state or states specified with \code{receiving} will get the reward.}

\item{receiving}{Character, name or names of states to which transitioning generates the reward. Can be both transient or absorbing states.}

\item{reward}{Numeric, reward value to be placed in matrix.}

\item{start_time}{Numeric (optional), value of time scale for start. If NULL (default) first value of time scale will be used.}

\item{end_time}{Numeric (optional), last value of time scale to consider. If NULL (default) all values of time scale starting from start_time will be used.}
}
\value{
A matrix with rewards.
}
\description{
This function generates a reward matrix which can be used with
\code{dtms_reward}.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
dtms_rewardmatrix(dtms=simple,receiving="B",reward=0.3)
}
\seealso{
[dtms_reward()]
}
