% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_nonparametric.R
\name{dtms_nonparametric}
\alias{dtms_nonparametric}
\title{Nonparametric estimates of transition probabilities}
\usage{
dtms_nonparametric(
  data,
  dtms,
  fromvar = "from",
  tovar = "to",
  timevar = "time",
  Pvar = "P",
  weights = NULL,
  se = TRUE,
  ci = FALSE,
  alpha = 0.05
)
}
\arguments{
\item{data}{Data frame in transition format, as created with \code{dtms_format}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{fromvar}{Character (optional), name of variable with starting state in `data`. Default is `from`.}

\item{tovar}{Character (optional), name of variable with receiving state in `data`. Default is `to`.}

\item{timevar}{Character (optional), name of variable with time scale in `data`. Default is `time`.}

\item{Pvar}{Character (optional), name of variable with transition probabilities in the returned data frame. Default is `P`.}

\item{weights}{Character (optional). Name of variable with survey weights.}

\item{se}{Logical (optional), return standard errors of predicted probabilities. Default is `TRUE`.}

\item{ci}{Logical (optional), return confidence intervals? See details. Default is FALSE.}

\item{alpha}{Numeric (optional), if ci=TRUE, what confidence level is used? Default is 0.05.}
}
\value{
A data frame with transition probabilities.
}
\description{
This function calculates nonparametric estimates of transition probabilities
for each value of the time scale.
}
\details{
The argument `data` takes a data set in transition format. Predicted
transition probabilities are returned as a data frame. Standard errors are
approximated using binomial standard errors. In case of small cell counts
this might be inaccurate.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Nonparametric transition probabilities
probs <- dtms_nonparametric(data=estdata,
                            dtms=simple)
}
