% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_fit.R
\name{dtms_fit}
\alias{dtms_fit}
\title{Estimate (un)constrained discrete-time multistate model}
\usage{
dtms_fit(
  data,
  controls = NULL,
  formula = NULL,
  weights = NULL,
  fromvar = "from",
  tovar = "to",
  reference = 1,
  package = "VGAM",
  full = FALSE,
  ...
)
}
\arguments{
\item{data}{Data frame in transition format, as created with \code{dtms_format}.}

\item{controls}{Character (optional), names of control variables}

\item{formula}{Formula (optional). If no formula is specified, it will be build from the information specified with controls, fromvar, tovar, and timevar.}

\item{weights}{Character (optional). Name of variable with survey weights.}

\item{fromvar}{Character (optional), name of variable in `data` with starting state. Default is "from".}

\item{tovar}{Character (optional), name of variable in `data` with receiving state. Default is "to".}

\item{reference}{Numeric or character (optional). Reference level of multinomial logistic regression.}

\item{package}{Character, chooses package for multinomial logistic regression, currently `VGAM`, `nnet`, and `mclogit` are supported. Default is `VGAM`.}

\item{full}{Logical (optional), estimate fully interacted model? Default is FALSE.}

\item{...}{Further arguments passed to estimation functions.}
}
\value{
Returns an object with class depending on the package used.
}
\description{
This function estimates a (un)constrained discrete-time multistate model
using multinomial logistic regression.
}
\details{
The argument `data` takes a data set in transition format. The model formula
can either be specified by using the argument `formula`. Alternatively, it
can be specified with the arguments `fromvar`, `tovar`, and `controls`. These
are used if `formula` is not specified. `fromvar` takes the name of the
variable with the starting state as a character string, `tovar` the same for
the receiving state, and `controls` is an optional vector of control
variables. `fromvar` and `tovar` have default values which match other
functions of this package, making them a convenient alternative to `formula`
(see example).

If `full=TRUE` a fully interacted model will be estimated in which each
control variable is interacted with all starting states. This is equivalent
to a full or unconstrained multistate model in which each transition is a
regression equation.

The argument `package` is used choose the package used for estimation.
Currently, `VGAM` (default), `nnet`, and `mclogit` are supported.
The functions used for estimation are, respectively, `vgam`, `multinom`,
and `mblogit`. Arguments for these functions are passed via `...`.

The argument `reference` sets the reference category for the multinomial
logistic regression. Weights for the regression can be passed via the
arguments `weights`. See the documentation of the package and function
used for estimation for details.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Fit model
fit <- dtms_fit(data=estdata)
}
