% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_boot_summary.R
\name{dtms_boot_summary}
\alias{dtms_boot_summary}
\title{Summary function for bootstrap results}
\usage{
dtms_boot_summary(boot, probs = NULL, alpha = 0.05)
}
\arguments{
\item{boot}{Object created with \code{dtms_boot()}.}

\item{probs}{Numeric (optional), vector of percentiles. Default is NULL.}

\item{alpha}{Numeric (optional), confidence level. Default is 0.05.}
}
\value{
Either a vector or a matrix.
}
\description{
Provides bootstrap percentiles for bootstrap replications created with
\code{dtms_boot()}.
}
\details{
Percentiles can be specified with the argument \code{probs}. This can be as
many percentiles as required by the user. If it is not
specified, the argument \code{alpha} is used instead. \code{alpha} is the
confidence level for the confidence intervals.

The function passed to \code{dtms_boot()} needs to either return a numeric
vector, a matrix, or a data.frame, otherwise \code{dtms_boot_summary()}
returns an error #' message. A data.frame will be transformed into a matrix.
}
\examples{

## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
# Bootstrap function
bootfun <- function(data,dtms) {
  fit <- dtms_fit(data=data)
  probs    <- dtms_transitions(dtms=dtms,
                               model = fit)
  S <- dtms_start(dtms=dtms,
                  data=data)
  dtms_expectancy(dtms=dtms,
                  probs=probs,
                  start_distr=S)
}
# Run bootstrap
bootstrap <- dtms_boot(data=estdata,
                       dtms=simple,
                       fun=bootfun,
                       rep=5)
summary(bootstrap,
        probs=c(0.025,0.5,0.975))
}
