% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{format_n_pct}
\alias{format_n_pct}
\title{Format count(s) and percentage(s) (\verb{n (pct\%)})}
\usage{
format_n_pct(n, pct, .pct_digits = 1L)
}
\arguments{
\item{n}{An integer vector of counts. Length must match that of \code{pct}.}

\item{pct}{A numeric vector of percentages. Length must match that of \code{n}.}

\item{.pct_digits}{Number of decimal places to format percentage values.
Defaults to \code{1}.}
}
\value{
A character vector of strings following the format \code{"n (pct\%)"},
except if \code{n} is zero, then the format is simply \code{"0"}.
}
\description{
\code{\link[=format_n_pct]{format_n_pct()}} formats counts (\code{n}) and respective percentages (\code{pct}) as
\code{"n (pct\%)"}.
}
\examples{
# Simple cases.
format_n_pct(n = 25, pct = 18.66)
format_n_pct(n = 25, pct = 18.66, .pct_digits = 2)

# If both `n` and `pct` are zero then the format is special, i.e. simply "0".
format_n_pct(n = 0, pct = 0)

# `format_n_pct()` is vectorised over `n` and `pct` but their length must
# match.
format_n_pct(n = c(20, 50), pct = c(10, 25))

# Missing values result in empty strings in the output.
format_n_pct(n = c(20, NA), pct = c(10, 25))
format_n_pct(n = c(20, 50), pct = c(10, NA))

}
\keyword{internal}
