% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-stats.R
\name{calc_desc}
\alias{calc_desc}
\title{Calculate descriptive summary statistics for a numeric variable}
\usage{
calc_desc(
  dt,
  target,
  target_name = target,
  treat,
  indent = nbsp(n = 4L),
  pct_dec = 1
)
}
\arguments{
\item{dt}{A \code{data.frame} containing, at least, the variables indicated in
\code{target} and \code{treat}.}

\item{target}{Target variable passed as a string for which summary
statistics are to be calculated.}

\item{target_name}{Heading for the target variable as a string. Defaults to
\code{target}.}

\item{treat}{A string indicating the grouping variable, e.g. the variable
specifying the treatment population.}

\item{indent}{A string to be used as indentation of summary statistics
labels. Defaults to four HTML non-breaking spaces (\verb{&nbsp;}).}

\item{pct_dec}{Decimal places for reported figures.}
}
\value{
A list containing a \code{data.table} formatted as follows:
\itemize{
\item First column is named \code{stats} and contains the target variable name
indicated in \code{target} in the first row. Subsequent rows contain the
summarised statistics labels.
\item Other columns are for the levels of the grouping variable (\code{treat}).
\item All columns are of character type.
}

This table is structured for easy integration with Shiny output widgets.
}
\description{
\code{\link[=calc_desc]{calc_desc()}} summarises a numeric variable (\code{target}) by another (\code{treat}) and
reports summary statistics in clinical trial reporting format. The following
statistics are calculated for \code{target}, per group, i.e. by variable \code{treat}
levels:
\itemize{
\item \code{n}: number of observations
\item \code{Mean (SD)}: mean and standard deviation of \code{target}
\item \code{Median}: median of \code{target}
\item \verb{Min, Max}: minimum and maximum of \code{target}
\item \code{Missing}: number of missing \code{target} values
}
}
\examples{
# Calculate summary statistics for the age of the subjects in each region.
calc_stats(dt = adsl, "AGE", treat = "REGION1")[[1]]

# Calculate summary statistics for biomarker 1 in each of the three arms
# (`ARM`).
calc_stats(dt = adsl, "BMRKR1", treat = "ARM")[[1]]

}
