% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_draw_ht.R
\name{generate_legend_bundle}
\alias{generate_legend_bundle}
\title{Generate a Bundle of Legends for Heatmap Components}
\usage{
generate_legend_bundle(
  sorted_dat,
  task = c("classification", "regression"),
  show = c("all", "train", "test"),
  type_cols = NULL,
  label_cols,
  prop_cols = NULL,
  col_mat,
  col_Col_Proximity = NULL,
  col_Row_Proximity = NULL,
  direction = c("vertical", "horizontal")
)
}
\arguments{
\item{sorted_dat}{List. Output of \code{sorted_mat()}, containing \code{sorted_test_matrix} and
\code{row_pro_mat_sorted}.}

\item{task}{Character. Type of task: "classification" or "regression".}

\item{show}{Character. Which subset: "all", "train" or "test".}

\item{type_cols}{Named vector of colors for feature type categories.}

\item{label_cols}{Named vector or function of colors for class label categories.}

\item{prop_cols}{Function. Color mapping function for membership proportion.}

\item{col_mat}{Function. Color mapping function for raw data values.}

\item{col_Col_Proximity}{Function. Color mapping function for column proximity.}

\item{col_Row_Proximity}{Function. Color mapping function for row proximity.}

\item{direction}{Character. Layout direction of packed legends, either "vertical" or "horizontal".}
}
\value{
A \code{ComplexHeatmap} packed Legend object containing all specified legends.
}
\description{
Creates and packs multiple legends (feature types, class labels, membership proportions,
raw values, and proximity metrics) into a single legend bundle for ComplexHeatmap.
}
\keyword{internal}
