% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_samplers.R
\name{btf_bspline0}
\alias{btf_bspline0}
\title{MCMC Sampler for B-spline Bayesian Trend Filtering: D = 0}
\usage{
btf_bspline0(
  y,
  times = NULL,
  num_knots = NULL,
  evol_error = "DHS",
  nsave = 1000,
  nburn = 1000,
  nskip = 4,
  mcmc_params = list("mu", "yhat", "beta", "evol_sigma_t2", "obs_sigma_t2", "dhs_phi",
    "dhs_mean"),
  computeDIC = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{y}{the \code{T x 1} vector of time series observations}

\item{times}{the \code{T x 1} vector of observation points; if NULL, assume equally spaced}

\item{num_knots}{the number of knots; if NULL, use the default of \code{max(20, min(ceiling(T/4), 150))}}

\item{evol_error}{the evolution error distribution; must be one of
'DHS' (dynamic horseshoe prior), 'HS' (horseshoe prior), 'BL' (Bayesian lasso), or 'NIG' (normal-inverse-gamma prior)}

\item{nsave}{number of MCMC iterations to record}

\item{nburn}{number of MCMC iterations to discard (burin-in)}

\item{nskip}{number of MCMC iterations to skip between saving iterations,
i.e., save every (nskip + 1)th draw}

\item{mcmc_params}{named list of parameters for which we store the MCMC output;
must be one or more of:
\itemize{
\item "mu" (conditional mean)
\item "beta" (B-spline basis coefficients)
\item "yhat" (posterior predictive distribution)
\item "evol_sigma_t2" (evolution error variance)
\item "obs_sigma_t2" (observation error variance)
\item "dhs_phi" (DHS AR(1) coefficient)
\item "dhs_mean" (DHS AR(1) unconditional mean)
}}

\item{computeDIC}{logical; if TRUE, compute the deviance information criterion \code{DIC}
and the effective number of parameters \code{p_d}}

\item{verbose}{logical; should R report extra information on progress?}
}
\value{
A named list of the \code{nsave} MCMC samples for the parameters named in \code{mcmc_params}
}
\description{
Run the MCMC for B-spline fitting with a penalty the B-spline basis coefficients.
The penalty is determined by the prior on the evolution errors, which include:
\itemize{
\item the dynamic horseshoe prior ('DHS');
\item the static horseshoe prior ('HS');
\item the Bayesian lasso ('BL');
\item the normal stochastic volatility model ('SV');
\item the normal-inverse-gamma prior ('NIG').
}
In each case, the evolution error is a scale mixture of Gaussians.
Sampling is accomplished with a (parameter-expanded) Gibbs sampler,
mostly relying on a dynamic linear model representation.
}
\note{
The data \code{y} may contain NAs, which will be treated with a simple imputation scheme
via an additional Gibbs sampling step. In general, rescaling \code{y} to have unit standard
deviation is recommended to avoid numerical issues.

The primary advantages of \code{btf_bspline} over \code{btf} are
\enumerate{
\item Unequally-spaced points are handled automatically and
\item Computations are linear in the number of basis coefficients, which may be
substantially fewer than the number of time points.
}
}
