% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsp_model.R, R/print.R
\name{dsp_fit}
\alias{dsp_fit}
\alias{print.dsp}
\title{MCMC Sampler for Models with Dynamic Shrinkage Processes}
\usage{
dsp_fit(
  y,
  model_spec,
  nsave = 1000,
  nburn = 1000,
  nskip = 4,
  computeDIC = TRUE,
  verbose = TRUE,
  ...
)

\method{print}{dsp}(x, ...)
}
\arguments{
\item{y}{a numeric vector of the \code{T x 1} vector of time series observations}

\item{model_spec}{a list containing model specification generated from \code{\link[=dsp_spec]{dsp_spec()}}.}

\item{nsave}{integer scalar (default = 1000); number of MCMC iterations to record}

\item{nburn}{integer scalar (default = 1000); number of MCMC iterations to discard (burn-in)}

\item{nskip}{integer scalar (default = 4); number of MCMC iterations to skip between saving iterations,
i.e., save every (nskip + 1)th draw}

\item{computeDIC}{logical; if TRUE (default), compute the deviance information criterion \code{DIC}
and the effective number of parameters \code{p_d}}

\item{verbose}{logical; should extra information on progress be printed to the console? Defaults to FALSE}

\item{...}{currently not used}

\item{x}{object of class dsp from \code{\link[=dsp_fit]{dsp_fit()}}}
}
\value{
\code{dsp_fit} returns an object of class "\code{dsp}".

An object of class "\code{dsp}" is defined as a list containing at least the following components:
\item{mcmc_output}{a list of the \code{nsave} MCMC samples for the parameters named in \code{mcmc_params}}
\item{DIC}{Deviance Information Criterion}
\item{mcpar}{named vector of supplied nsave, nburn, and nskip}
\item{model_spec}{the object supplied for model_spec argument}
}
\description{
Wrapper function for fitting models with Dynamic Shrinkage Processes (DSP), including:
\itemize{
\item Adaptive Bayesian Changepoint analysis and local Outlier (ABCO),
\item Bayesian Trend Filter for Gaussian Data
\item Time-varying Regression
\item Bayesian Trend Filter with B-spline for irregularly spaced or functional time-series.
\item Bayesian Smoothing for Count Data
}

Method for printing basic information about the MCMC sampling settings for the fitted model
}
\details{
A brief summary of the settings used to fit the model including number of iterations,
burn in, and thinning rates.
}
\note{
The data \code{y} may contain NAs, which will be treated with a simple imputation scheme
via an additional Gibbs sampling step. In general, rescaling \code{y} to have unit standard
deviation is recommended to avoid numerical issues when family is "gaussian".
}
\examples{
set.seed(200)
signal = c(rep(0, 50), rep(10, 50))
noise = rep(1, 100)
noise_var = rep(1, 100)
for (k in 2:100){
  noise_var[k] = exp(0.9*log(noise_var[k-1]) + rnorm(1, 0, 0.5))
  noise[k] = rnorm(1, 0, sqrt(noise_var[k])) }

y = signal + noise
model_spec = dsp_spec(family = "gaussian", model = "changepoint",
                      D = 1, useAnom = TRUE, obsSV = "SV")
mcmc_output = dsp_fit(y, model_spec = model_spec, nsave = 500, nburn = 500)

print(mcmc_output)

}
