% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue-permutations.R
\name{pt_from_os}
\alias{pt_from_os}
\title{Permutation Test from Outlier Scores}
\usage{
pt_from_os(os_train, os_test, n_pt = 2000)
}
\arguments{
\item{os_train}{Outlier scores in training (reference) set.}

\item{os_test}{Outlier scores in test set.}

\item{n_pt}{The number of permutations.}
}
\value{
A named list of class \code{outlier.test} containing:
\itemize{
   \item \code{statistic}: observed WAUC statistic
   \item \code{seq_mct}: sequential Monte Carlo test, when applicable
   \item \code{p_value}: p-value
   \item \code{outlier_scores}: outlier scores from training and test set
}
}
\description{
Test for no adverse shift with outlier scores. Like goodness-of-fit testing,
this two-sample comparison takes the training (outlier) scores,
\code{os_train}, as the reference. The method checks whether the test
scores, \code{os_test}, are worse off relative to the training set.
}
\details{
The null distribution of the test statistic is based on \code{n_pt}
permutations. For speed, this is implemented as a sequential Monte Carlo test
with the \pkg{simctest} package. See Gandy (2009) for details. The prefix
\emph{pt} refers to permutation test. This approach does not use the
asymptotic null distribution for the test statistic. This is the recommended
approach for small samples. The test statistic is the weighted AUC (WAUC).
}
\section{Notes}{

The outlier scores should all mimic out-of-sample behaviour. Mind that the
training scores are not in-sample and thus, biased (overfitted) while the
test scores are out-of-sample. The mismatch -- in-sample versus out-of-sample
scores -- voids the test validity. A simple fix for this is to get the
training scores from an indepedent (fresh) validation set; this follows
the train/validation/test sample splitting convention and the validation set
is effectively the reference set or distribution in this case.
}

\examples{
\donttest{
library(dsos)
set.seed(12345)
os_train <- rnorm(n = 100)
os_test <- rnorm(n = 100)
null_test <- pt_from_os(os_train, os_test)
null_test
}

}
\references{
Kamulete, V. M. (2022).
\emph{Test for non-negligible adverse shifts}.
In The 38th Conference on Uncertainty in Artificial Intelligence. PMLR.

Gandy, A. (2009).
\emph{Sequential implementation of Monte Carlo tests with uniformly bounded resampling risk}.
Journal of the American Statistical Association, 104(488), 1504-1511.
}
\seealso{
[pt_oob()] for variant requiring a scoring function.
[at_from_os()] for asymptotic test with the outlier scores.

Other permutation-test: 
\code{\link{pt_oob}()},
\code{\link{pt_refit}()}
}
\concept{permutation-test}
