% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsm-package.R
\name{dsm-data}
\alias{dsm-data}
\title{Data format for DSM}
\description{
Two \code{data.frame}s must be provided to \code{\link{dsm}}. They are referred to as
\code{observation.data} and \code{segment.data}.
}
\details{
The \code{segment.data} table has the sample identifiers which define the
segments, the corresponding effort (line length) expended and the
environmental covariates that will be used to model abundance/density.
\code{observation.data} provides a link table between the observations used in
the detection function and the samples (segments), so that we can aggregate
the observations to the segments (i.e., \code{observation.data} is a "look-up
table" between the observations and the segments).

\code{observation.data} - the observation \code{data.frame} must have (at least) the
following columns:
\itemize{
\item \code{object} unique object identifier
\item \code{Sample.Label} the identifier for the segment where observation occurred
\item \code{size} the size of each observed group (e.g., 1 if all animals occurred
individually)
\item \code{distance} distance to observation
}

One can often also use \code{observation.data} to fit a detection function (so
additional columns for detection function covariates are allowed in this
table).

\code{segment.data}: the segment \code{data.frame} must have (at least) the following
columns:
\itemize{
\item \code{Effort} the effort (in terms of length of the segment)
\item \code{Sample.Label} identifier for the segment (unique!)
\item ??? environmental covariates, for example location (projected latitude
and longitude), and other relevant covariates (sea surface temperature,
foliage type, altitude, bathymetry etc).
}
}
\section{Multiple detection functions}{


If multiple detection functions are to be used, then a column named \code{ddfobj}
must be included in \code{observation.data} and \code{segment.data}. This lets the
model know which detection function each observation is from. These are
numeric and ordered as the \code{ddf.obj} argument to \code{\link{dsm}}, e.g.,
\code{ddf.obj=list(ship_ddf, aerial_ddf)} means ship detections have \code{ddfobj=1}
and aerial detections have \code{ddfobj=2} in the observation data.
}

\section{Mark-recapture distance sampling models}{


When using \code{mrds} models that include mark-recapture components (currently
independent observer and trial modes are supported) then the format of the
observation data needs to be checked to ensure that observations are not
duplicated. The \code{observer} column is also required in the
\code{observation.data}.
\itemize{
\item \emph{Independent observer mode} only unique observations (unique object IDs)
are required.
\item \emph{Trial mode} only observations made by observer 1 are required.
}
}

