% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsDS.R
\name{lsDS}
\alias{lsDS}
\title{lists all objects on a serverside environment}
\usage{
lsDS(search.filter = NULL, env.to.search)
}
\arguments{
\item{search.filter}{either NULL or a character string (potentially including '*'
wildcards) specifying required search criteria. This argument is
fully specified by its corresponding argument in the clientside function.}

\item{env.to.search}{integer (e.g. in a format such as '2' or '5L' format) specifying
the position in the search path of the environment to be explored. This argument is
fully specified by its corresponding argument in the clientside function.}
}
\value{
a list containing: (1) the name/details of the serverside R environment
which \code{ds.ls} has searched; (2) a vector of character strings giving the names of
all objects meeting the naming criteria specified by the argument <search.filter> in this
specified R serverside environment; (3) the nature of the search filter string as it was
actually applied
}
\description{
creates a list of the names of all of the objects in
a specified serverside environment
}
\details{
Serverside aggregate function \code{lsDS} called by clientside function
\code{ds.ls}. When running analyses one may want to know the objects already generated. This 
request is not disclosive as it only returns the names of the objects and not their contents. 
By default, objects in the current 'active analytic environment' (".GlobalEnv")
will be displayed. This
is the environment that contains all of the objects that serverside DataSHIELD 
is using for the main analysis or has written out to the serverside during the process
of managing or undertaking the analysis (variables, scalars, matrices, data.frames etc).
For further details see help for \code{ds.ls} function and for native R function \code{ls}
}
\author{
Gaye, A (2015). Updated and extended by Paul Burton (2020).
}
