% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.boxPlotGG.R
\name{ds.boxPlotGG}
\alias{ds.boxPlotGG}
\title{Renders boxplot}
\usage{
ds.boxPlotGG(
  x,
  group = NULL,
  group2 = NULL,
  xlabel = "x axis",
  ylabel = "y axis",
  type = "pooled",
  datasources = NULL
)
}
\arguments{
\item{x}{\code{character} Name on the server side of the data frame to form a boxplot. Structure on the server 
of this object must be: \cr

 Column 'x': Names on the X axis of the boxplot, aka variables to plot \cr
 Column 'value': Values for that variable (raw data of columns rbinded) \cr
 Column 'group': (Optional) Values of the grouping variable \cr
 Column 'group2': (Optional) Values of the second grouping variable \cr}

\item{group}{\code{character} (default \code{NULL}) Name of the first grouping variable.}

\item{group2}{\code{character} (default \code{NULL}) Name of the second grouping variable.}

\item{xlabel}{\code{caracter} (default \code{"x axis"}) Label to put on the x axis of the plot}

\item{ylabel}{\code{caracter} (default \code{"y axis"}) Label to put on the y axis of the plot}

\item{type}{\code{character} Return a pooled plot (\code{"pooled"}) or a split plot (one for each study server
\code{"split"})}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} (default \code{NULL}) objects obtained after login}
}
\value{
\code{ggplot} object
}
\description{
Internal function. Renders a ggplot boxplot by retrieving from the server side a list with the identity stats and other
parameters to render the plot without passing any data from the original dataset
}
