% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_bias.R
\name{Ed3_bias}
\alias{Ed3_bias}
\alias{Ed3_L}
\alias{Ed3_L2}
\alias{Ed3_R}
\alias{Ed3_R2}
\title{Expected sample size for phase III for bias adjustment programs and time-to-event outcomes}
\usage{
Ed3_L(HRgo, d2, Adj, alpha, beta, w, hr1, hr2, id1, id2, fixed)

Ed3_L2(HRgo, d2, Adj, alpha, beta, w, hr1, hr2, id1, id2, fixed)

Ed3_R(HRgo, d2, Adj, alpha, beta, w, hr1, hr2, id1, id2, fixed)

Ed3_R2(HRgo, d2, Adj, alpha, beta, w, hr1, hr2, id1, id2, fixed)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule}

\item{d2}{total events for phase II; must be even number}

\item{Adj}{adjustment parameter}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{hr1} is used as fixed effect}
}
\value{
The output of the functions \code{Ed3_L}, \code{Ed3_L2}, \code{Ed3_R} and \code{Ed3_R2} is the expected number of participants in phase III.
}
\description{
To discount for overoptimistic results in phase II when calculating the optimal sample size in phase III,
it is necessary to use the functions \code{Ed3_L()}, \code{Ed3_L2()}, \code{Ed3_R()} and \code{Ed3_R2()}.
Each function describes a specific case:
\itemize{
\item \code{Ed3_L()}: calculates the optimal sample size for an additive adjustment factor (i.e. adjust the lower bound of the one-sided confidence interval),
however the go-decision is not affected by the bias adjustment
\item \code{Ed3_L2()}: calculates the optimal sample size for an additive adjustment factor (i.e. adjust the lower bound of the one-sided confidence interval)
when the go-decision is also affected by the bias adjustment
\item \code{Ed3_R()}: calculates the optimal sample size for a multiplicative adjustment factor (i.e. use estimate with a retention factor),
however the go-decision is not affected by the bias adjustment
\item \code{Ed3_R2()}: calculates the optimal sample size for a multiplicative adjustment factor (i.e. use estimate with a retention factor)
when the go-decision is also affected by the bias adjustment
}
}
\examples{
res <-  Ed3_L(HRgo = 0.8, d2 = 50, Adj = 0.4,
                        alpha = 0.025, beta = 0.1, w = 0.3, 
                        hr1 =  0.69, hr2 = 0.81, 
                        id1 = 280, id2 = 420, fixed = FALSE)
          res <-  Ed3_L2(HRgo = 0.8, d2 = 50, Adj = 0.4,
                        alpha = 0.025, beta = 0.1, w = 0.3, 
                        hr1 =  0.69, hr2 = 0.81, 
                        id1 = 280, id2 = 420, fixed = FALSE)
          res <- Ed3_R(HRgo = 0.8, d2 = 50, Adj = 0.9,
                        alpha = 0.025, beta = 0.1, w = 0.3, 
                        hr1 =  0.69, hr2 = 0.81, 
                        id1 = 280, id2 = 420, fixed = FALSE)
          res <- Ed3_R2(HRgo = 0.8, d2 = 50, Adj = 0.9,
                        alpha = 0.025, beta = 0.1, w = 0.3, 
                        hr1 =  0.69, hr2 = 0.81, 
                        id1 = 280, id2 = 420, fixed = FALSE)
                              
}
\keyword{internal}
