% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau.R
\name{tau}
\alias{tau}
\title{Compute Estimated LATE}
\usage{
tau(muY1, muY0, muD1, muD0, A, S, Y, D, stratnum = NULL)
}
\arguments{
\item{muY1}{A nx1 vector of hat\{mu\}^Y(A=1)s.}

\item{muY0}{A nx1 vector of hat\{mu\}^Y(A=0)s.}

\item{muD1}{A nx1 vector of hat\{mu\}^D(A=1)s.}

\item{muD0}{A nx1 vector of hat\{mu\}^D(A=0)s.}

\item{A}{A nx1 vector. Each of its elements is the treatment assignment of the corresponding observation.}

\item{S}{A nx1 vector. Each of its elements is the stratum of corresponding observation.}

\item{Y}{A nx1 vector. Each of its elements is the observed outcome of interest of corresponding observation.}

\item{D}{A nx1 vector. Each of its elements is is a binary random variable indicating whether the individual i received treatment (Di = 1) or not (Di = 0) in the actual study.}

\item{stratnum}{A nx1 vector about the unique strata numbers, the default value is NULL.}
}
\value{
A scalar. LATE estimate.
}
\description{
Computes the estimated LATE in Jiang et al. (2022).
}
\examples{
DGP <- FuncDGP(dgptype = 1, rndflag = 1, n = 200, g = 4, pi = c(0.5, 0.5, 0.5, 0.5))
muY1 <- DGP[["Y1"]]
muY0 <- DGP[["Y0"]]
muD1 <- DGP[["D1"]]
muD0 <- DGP[["D0"]]
A <- DGP[["A"]]
S <- DGP[["S"]]
Y <- DGP[["Y"]]
D <- DGP[["D"]]
tau(muY1, muY0, muD1, muD0, A, S, Y, D)


}
\references{
Jiang L, Linton O B, Tang H, Zhang Y. Improving estimation efficiency via regression-adjustment in covariate-adaptive randomizations with imperfect compliance [J]. 2022.
}
