% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scans.R
\name{estimateP}
\alias{estimateP}
\title{Estimate a starting value for penalty P.}
\usage{
estimateP(x, y, plot = FALSE, ...)
}
\arguments{
\item{x}{x-values}

\item{y}{y-values}

\item{plot}{plot the \code{\link{smooth.spline}}}

\item{...}{parameters for \code{\link{smooth.spline}}}
}
\value{
Returns a double, variance of residuals of a spline fit
    (\code{var(smooth.spline(x,y, ...)$y -y)})
}
\description{
The break-point penalty P in a \code{\link{dpseg}} recursion,
should be in the range of expected values of the scoring
function. To find a good initial estimate for P when using the
default scoring fuction (see \code{\link{dpseg}}), the data is
smoothed by \code{smooth.spline} and the variance of residuals
reported.
}
\examples{
x <- oddata$Time
y <- log(oddata$A5)
p <- estimateP(x=x, y=y, plot=TRUE)
plot(dpseg(x=x, y=y, jumps=TRUE, P=round(p,3)))
}
