% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{getTimeTrees}
\alias{getTimeTrees}
\title{Estimate time trees by running BEAST on each clone
Applies XML \code{template} to each clone}
\usage{
getTimeTrees(
  clones,
  template,
  beast,
  dir,
  id,
  time,
  mcmc_length = 3e+07,
  log_every = "auto",
  burnin = 10,
  trait = NULL,
  resume_clones = NULL,
  nproc = 1,
  quiet = 0,
  rm_temp = FALSE,
  include_germline = TRUE,
  seq = "sequence",
  germline_range = c(-10000, 10000),
  java = TRUE,
  seed = NULL,
  log_target = 10000,
  tree_states = FALSE,
  trees = NULL,
  ...
)
}
\arguments{
\item{clones}{a tibble of \code{airrClone} objects, the output of
\link{formatClones}}

\item{template}{XML template}

\item{beast}{location of beast binary directory (beast/bin)}

\item{dir}{directory where temporary files will be placed.}

\item{id}{unique identifer for this analysis}

\item{time}{Name of sample time column}

\item{mcmc_length}{Number of MCMC steps}

\item{log_every}{Frequency of states logged. "auto" will divide
mcmc_length by log_target}

\item{burnin}{Burnin percent (default 10)}

\item{trait}{Trait column to be used}

\item{resume_clones}{Clones to resume for \code{mcmc_length} more steps}

\item{nproc}{Number of cores for parallelization. At most 1 core/tree can be used.}

\item{quiet}{amount of rubbish to print to console}

\item{rm_temp}{remove temporary files (default=TRUE)}

\item{include_germline}{Include germline sequence in analysis?}

\item{seq}{Sequence column in data}

\item{germline_range}{Possible date range of germline tip}

\item{java}{Use the -java flag for BEAST run}

\item{seed}{Use specified seeed for the -seed option for BEAST}

\item{log_target}{Target number of samples from MCMC chain}

\item{tree_states}{Use \code{states} vector for starting tree}

\item{trees}{optional list of starting trees, either phylo objects or newick strings}

\item{...}{Additional arguments passed to tree building programs}
}
\value{
A tibble with a column of \code{phylo} objects and \code{parameters} column
}
\description{
\code{getTimeTrees} Tree building function.
}
\details{
For examples and vignettes, see https://dowser.readthedocs.io
}
\seealso{
\link{getTrees}, \link{readBEAST}
}
