% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosresmeta.R
\name{mlprof.fun}
\alias{mlprof.fun}
\alias{remlprof.fn}
\alias{remlprof.gr}
\alias{mlprof.fn}
\alias{mlprof.gr}
\alias{iter.igls}
\title{Likelihood Functions for dosresmeta Models}
\usage{
remlprof.fn(par, Xlist, Zlist, ylist, Slist, nalist, q, nall, ctrl)

remlprof.gr(par, Xlist, ylist, Slist, nalist, p, nall, ctrl)

mlprof.fn(par, Xlist, Zlist, ylist, Slist, nalist, q, nall, ctrl)

mlprof.gr(par, Xlist, ylist, Slist, nalist, p, nall, ctrl)

iter.igls(Psi, Xlist, Zlist, ylist, Slist, nalist, q)
}
\arguments{
\item{par}{a vector representing the random-effects parameters defining the between-study (co)variance matrix.}

\item{Xlist}{a m-dimensional list of study-specific design matrices for the fixed-effects part of the model.}

\item{Zlist}{a m-dimensional list of study-specific design matrices for the random-effects part of the model.}

\item{ylist}{a m-dimensional list of study-specific of vectors of estimated outcomes.}

\item{Slist}{a m-dimensional list of within-study (co)variance matrices of estimated outcomes.}

\item{nalist}{a m-dimensional list of k-dimensional study-specific logical vectors, identifying missing outcomes.}

\item{ctrl}{list of parameters for controlling the fitting process, usually internally set to default values by 
\code{dosresmeta.control}.}

\item{p, q, nall}{numeric scalars: number of predictors, number of observations (excluding missing).}

\item{Psi}{a p x p matrix representing the current estimate of the between-study (co)variance matrix.}
}
\value{
\code{mlprof.fn} and \code{remlprof.fn} return the value of the (restricted) log-likelihood for a given set of 
parameters in \code{par}. \code{iter.igls} returns an updated estimate of \code{Psi} given its initial value or the value at 
the previous iteration.
}
\description{
These functions compute the value of the log-likelihood for random-effects dose-response meta-analysis,
 in terms of model parameters. They are meant to be used internally and not directly run by the users.
}
\details{
These functions are called internally by the fitting functions \code{\link{dosresmeta.ml}} and \code{\link{dosresmeta.reml}} to 
perform iterative optimization algorithms for estimating random effects meta-analytical models.

The maximization of the (restricted) likelihood starts with few runs of an iterative generalized least square algorithm implemented in \code{iter.igls}. 
This can be regarded as a fast and stable way to get starting values close to the maximum for the Quasi-Newton iterative algorithm, implemented in 
\code{\link{optim}}. Alternatively, starting values can be provided by the user in the control list (see \code{\link[mixmeta]{mixmeta.control}}). 

These functions actually specify the profiled version of the (restricted) likelihood, expressed only in terms of random-effects parameters, while the 
estimate of the fixed-effects coefficients is provided at each iteration by the internal function \code{glsfit}, based on the current value of 
the between-study (co)variance matrix. At convergence, the value of this profiled version is identical to the full (restricted) likelihood. 
This approach is computationally efficient, as it reduces the number of parameters in the optimization routine.

The parameterization of the between-study (co)variance matrix ensures the positive-definiteness of the estimated matrix. A Cholesky decomposition is then 
performed on the marginal (co)variance matrix in order to re-express the problem as standard least square equations, an approach which speeds up the 
computation of matrix inverses and determinants. These equations are finally solved through a QR decomposition, which guarantees stability.
}
\seealso{
\code{dosresmeta}, \code{\link[mixmeta]{mixmeta.fit}}, \code{\link{dosresmeta.control}}, \code{\link{mlprof.fn}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
