% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opti_helpers.R
\name{prob_bounds}
\alias{prob_bounds}
\title{A function to find the maximum and minimum probability of a permutation.}
\usage{
prob_bounds(z, gamma)
}
\arguments{
\item{z}{vector of doses}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}
}
\value{
a list containing the maximum and minimum probability of a permutation
under the Rosenbaum model with doses z and unmeasured confounding level gamma.
}
\description{
A function to find the maximum and minimum probability of a permutation.
}
\examples{
# A vector of observed doses
doses <- c(0, 0.1, 0.4, 0.8)
bounds <- prob_bounds(z = doses, gamma = 1)
}
