% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharp.R
\name{dev_TV}
\alias{dev_TV}
\title{Computes deviation from uniform distribution in total variation
distance for a given amount of unmeasured confounding and a greater than
alternative with a binary outcome.}
\usage{
dev_TV(Z, Q, index, gamma, direct = "upper")
}
\arguments{
\item{Z}{A length N vector of (nonnegative) observed doses.}

\item{Q}{A length N vector of observed binary outcomes.}

\item{index}{A length N vector of indices indicating matched set membership.}

\item{gamma}{The nonnegative sensitivity parameter; gamma = 0 means no
unmeasured confounding.}

\item{direct}{The direction of the test - "upper" or "lower"; default is upper.}
}
\value{
A vector of length equaling the number of matched sets consisting
of the TV distance from the uniform for each matched set at gamma level of
unmeasured confounding for the worst-case.
}
\description{
Computes deviation from uniform distribution in total variation
distance for a given amount of unmeasured confounding and a greater than
alternative with a binary outcome.
}
\examples{
# Load the data
data <- lead_crime
# compute total variation distances.
total_variation <- dev_TV(data$log_lead, data$complain,
data$matched_sets, gamma = log(1.5))
}
