% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso.R
\name{dodgr_isoverts}
\alias{dodgr_isoverts}
\title{Calculate isodistance or isochrone vertices from specified points.}
\usage{
dodgr_isoverts(graph, from = NULL, dlim = NULL, tlim = NULL, heap = "BHeap")
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph. For \code{dodgr} street networks, this must be a network derived from
\pkg{silicate} ("sc") data, generated with \link{weight_streetnet}. This
function does not work with networks derived from \pkg{sf} data.}

\item{from}{Vector or matrix of points \strong{from} which isodistances or
isochrones are to be calculated.}

\item{dlim}{Vector of desired limits of isodistances in metres.}

\item{tlim}{Vector of desired limits of isochrones in seconds}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}
}
\value{
A single \code{data.frame} of vertex IDs, with columns denoting the \code{from}
points and \code{tlim} value(s). The isochrones are given as \code{id} values and
associated coordinates of the series of points from each \code{from} point at the
specified isochrone times.

Isoverts are calculated by default using parallel computation with the
maximal number of available cores or threads. This number can be reduced by
specifying a value via \verb{RcppParallel::setThreadOptions (numThreads = <desired_number>)}.
}
\description{
Returns lists of all network vertices contained within
isodistance or isochrone contours. Input objects must be \code{data.frame}
objects (\code{graph}), which must minimally contain three columns of \code{from},
\code{to}, and \code{d} or \code{dist}. If an additional column named \code{weight} or \code{wt} is
present, iso contours are evaluate via shortest paths calculated according
to values specified in that column, while resultant values of iso contours
are calculated from the \code{d} or \code{dist} column. That is, the paths tracing iso
contours from any point will be calculated according to the minimal total
sum of \code{weight} values (if present), while reported iso contours will be
total sums of \code{dist} values.

Graphs derived from Open Street Map street networks, via the
\link{weight_streetnet} function, have columns labelled \code{d}, \code{d_weighted},
\code{time}, and \code{time_weighted}. For these inputs, iso contours are always
routed using \code{d_weighted} (or \code{t_weighted} for times), while final iso
contours reflect sums of values of \code{d} (or \code{t} for times) - that is, of
un-weighted distances or times - along those paths.

Function is fully vectorized to accept vectors of central points and vectors
defining multiple isochrone or isodistance thresholds. Provide one or more
\code{dlim} values for isodistances, or one or more \code{tlim} values for isochrones.
Calculations use by default parallel computation with the maximal number of
available cores or threads. This number can be reduced by specifying a value
via \verb{RcppParallel::setThreadOptions (numThreads = <desired_number>)}.
}
\examples{
\dontrun{
# Use osmdata package to extract 'SC'-format data:
library (osmdata)
dat <- opq ("hampi india") \%>\%
    add_osm_feature (key = "highway") \%>\%
    osmdata_sc ()
graph <- weight_streetnet (dat)
from <- sample (graph$.vx0, size = 100)
tlim <- c (5, 10, 20, 30, 60) * 60 # times in seconds
x <- dodgr_isoverts (graph, from = from, tlim)
}
}
\seealso{
Other iso: 
\code{\link{dodgr_isochrones}()},
\code{\link{dodgr_isodists}()}
}
\concept{iso}
