% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{expectRaw-tag}
\alias{expectRaw-tag}
\alias{@expectRaw}
\title{Create an expectation as-is}
\description{
\verb{@expectRaw} creates an expectation for your example code, without adding
the next expression as the subject.
}
\details{
\verb{@expectRaw} creates a \link[testthat:testthat-package]{testthat} expectation.
Unlike \link{@expect}, it doesn't insert the subsequent expression as the first
argument.

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @doctest
#'
#' x <- 2 + 2
#' @expectRaw equals(x, 4)
#'
#' f <- function () warning("Watch out")
#' @expectRaw warning(f())
}\if{html}{\out{</div>}}

Don't include the \code{expect_} prefix.

The \verb{@expectRaw} tag and code must fit on a single line.
}
\seealso{
Other expectations: 
\code{\link{expect-tag}},
\code{\link{snap-tag}}
}
\concept{expectations}
