% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramest.R
\name{paramEdge}
\alias{paramEdge}
\title{Parameter estimation for static vertex case.}
\usage{
paramEdge(
  input_network,
  model.terms,
  model.formula,
  graph_mode = "digraph",
  group,
  intercept = c("edges"),
  exvar = NA,
  maxlag = 3,
  lagmat = matrix(sample(c(0, 1), (maxlag + 1) * length(model.terms), replace = T),
    ncol = length(model.terms)),
  ylag = rep(1, maxlag),
  lambda = NA,
  method = "glmnet",
  alpha.glmnet = 1,
  paramout = TRUE
)
}
\arguments{
\item{input_network}{Input network.}

\item{model.terms}{model terms, must be ERGM terms expanded.}

\item{model.formula}{ERGM formula for each time point.}

\item{graph_mode}{'digraph' by default for bidirectional.}

\item{group}{grouping covariates for vertices.}

\item{intercept}{intercept terms.}

\item{exvar}{Extraneous variables}

\item{maxlag}{maximum lag.}

\item{lagmat}{Matrix of dimension (maxlag+1)x(length(model.terms))}

\item{ylag}{lag vectors of length=maxlag.}

\item{lambda}{NA}

\item{method}{Regression method, default is 'bayesglm'}

\item{alpha.glmnet}{if regularization is used. not needed for bayesglm.}

\item{paramout}{TRUE by default. if parameters are needed.}
}
\value{
list with elements:
  coef: coefficients
  mplematfull: full matrix of change statistics
  mplemat: subset of matrix of change statistics
}
\description{
Parameter estimation for the static vertex case.
}
\examples{
\dontrun{
input_network=rdNets[1:6]
model.terms=c("triadcensus.003", "triadcensus.012", "triadcensus.102", "triadcensus.021D", "gwesp");
model.formula = net~triadcensus(0:3)+gwesp(decay=0, fixed=FALSE, cutoff=30)-1;
graph_mode='digraph';
group='dnc';
alpha.glmnet=1
directed=TRUE;
method <- 'bayesglm'
maxlag <- 3
lambda=NA
intercept = c("edges")
cdim <- length(model.terms)
lagmat <- matrix(sample(c(0,1),(maxlag+1)*cdim,replace = TRUE),ncol = cdim)
ylag <- rep(1,maxlag)
exvar <- NA
out <- paramEdge(input_network,model.terms, model.formula,
                graph_mode='digraph',group,intercept = c("edges"),exvar=NA,
                maxlag = 3,
                lagmat = matrix(sample(c(0,1),(maxlag+1)*cdim,
                                       replace = TRUE),ncol = cdim),
                ylag = rep(1,maxlag),
                lambda = NA, method='bayesglm',
                alpha.glmnet=1)}

}
\author{
Abhirup
}
