% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combdist.R
\name{combdist_plt}
\alias{combdist_plt}
\title{Combined coefficients of power-law transformed combined distribution}
\usage{
combdist_plt(
  dist,
  prior = NULL,
  coeff,
  a = 1,
  b = 1,
  inv = FALSE,
  nested = FALSE
)
}
\arguments{
\item{dist}{character vector denoting the distribution(s).}

\item{prior}{Numeric vector of prior coefficients, defaults to single vector with value one.}

\item{coeff}{list of parameters for the distribution(s).}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}

\item{nested}{logical indicating whether results should be returned in a nested list or flat list, defaults to FALSE.}
}
\value{
Returns a nested or flat list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}
}
\description{
Coefficients of a power-law transformed combined distribution
}
\examples{

\donttest{

# Load necessary tools
data("fit_US_cities")
library(tidyverse)


## Comparing probabilites of power-law transformed transformed variables
prob <- fit_US_cities \%>\%
  filter(!(dist \%in\% c(
    "exp", "invpareto_exp_pareto", "exp_pareto", "invpareto_exp",
    "gamma", "invpareto_gamma_pareto", "gamma_pareto", "invpareto_gamma"
  ))) \%>\%
  group_by(dist, components, np, n) \%>\%
  do(prob = pcombdist(q = 1.1, dist = .[["dist"]], prior = .[["prior"]][[1]],
  coeff = .[["coefficients"]][[1]])) \%>\%
  unnest(cols = c(prob))
fit_US_cities_plt <- fit_US_cities \%>\%
  filter(!(dist \%in\% c(
    "exp", "invpareto_exp_pareto", "exp_pareto", "invpareto_exp",
    "gamma", "invpareto_gamma_pareto", "gamma_pareto", "invpareto_gamma"
  ))) \%>\%
  group_by(dist, components, np, n, convergence) \%>\%
  do(results = as_tibble(combdist_plt(dist = .[["dist"]], prior = .[["prior"]][[1]],
  coeff = .[["coefficients"]][[1]], a = 2, b = 0.5, nested = TRUE))) \%>\%
  unnest(cols = c(results))
prob$prob_plt <- fit_US_cities_plt \%>\%
  group_by(dist, components, np, n) \%>\%
  do(prob_plt = pcombdist(q = 2 * 1.1^0.5, dist = .[["dist"]], prior = .[["prior"]][[1]],
  coeff = .[["coefficients"]][[1]])) \%>\%
  unnest(cols = c(prob_plt)) \%>\%
  .$prob_plt
prob <- prob \%>\%
  mutate(check = abs(prob - prob_plt))

prob <- fit_US_cities \%>\%
  filter(!(dist \%in\% c(
    "exp", "invpareto_exp_pareto", "exp_pareto", "invpareto_exp",
    "gamma", "invpareto_gamma_pareto", "gamma_pareto", "invpareto_gamma"
  ))) \%>\%
  group_by(dist, components, np, n) \%>\%
  do(prob = pcombdist(q = 2 * 1.1^0.5, dist = .[["dist"]], prior = .[["prior"]][[1]],
  coeff = .[["coefficients"]][[1]])) \%>\%
  unnest(cols = c(prob))
fit_US_cities_plt <- fit_US_cities \%>\%
  filter(!(dist \%in\% c(
    "exp", "invpareto_exp_pareto", "exp_pareto", "invpareto_exp",
    "gamma", "invpareto_gamma_pareto", "gamma_pareto", "invpareto_gamma"
  ))) \%>\%
  group_by(dist, components, np, n, convergence) \%>\%
  do(results = as_tibble(combdist_plt(dist = .[["dist"]], prior = .[["prior"]][[1]],
  coeff = .[["coefficients"]][[1]], a = 2, b = 0.5, nested = TRUE, inv = TRUE))) \%>\%
  unnest(cols = c(results))
prob$prob_plt <- fit_US_cities_plt \%>\%
  group_by(dist, components, np, n) \%>\%
  do(prob_plt = pcombdist(q = 1.1, dist = .[["dist"]], prior = .[["prior"]][[1]],
  coeff = .[["coefficients"]][[1]])) \%>\%
  unnest(cols = c(prob_plt)) \%>\%
  .$prob_plt
prob <- prob \%>\%
  mutate(check = abs(prob - prob_plt))
}

}
