% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_survival.R
\name{eval_survival}
\alias{eval_survival}
\alias{enframe_survival}
\title{Survival Function}
\usage{
eval_survival(distribution, at)

enframe_survival(..., at, arg_name = ".arg", fn_prefix = "survival", sep = "_")
}
\arguments{
\item{distribution, ...}{A distribution, or possibly multiple
distributions in the case of \code{...}.}

\item{at}{Vector of values to evaluate the representation at.}

\item{arg_name}{For \code{enframe_}, name of the column containing
the function arguments. Length 1 character vector.}

\item{fn_prefix}{For \code{enframe_}, name of the function to
appear in the column(s). Length 1 character vector.}

\item{sep}{When \code{enframe}'ing more than one distribution, the
character that will be separating the \code{fn_name} and the distribution name.
Length 1 character vector.}
}
\value{
The evaluated representation in vector form (for \code{eval_})
with length matching the length of \code{at}, and data frame
or tibble form (for \code{enframe_}) with number of rows matching the
length of \code{at}. The \code{at} input occupies the first column,
named \code{.arg} by default, or the specification in \code{arg_name};
the evaluated representations for each distribution in \code{...}
go in the subsequent columns (one column per distribution). For a
single distribution, this column is named according to the
representation by default (cdf, survival, quantile, etc.),
or the value in \code{fn_prefix}. For multiple distributions, unnamed
distributions are auto-named, and columns are named
\verb{<fn_prefix><sep><distribution_name>} (e.g., \code{cdf_distribution1}).
}
\description{
Access a distribution's survival function.
}
\examples{
d <- dst_unif(0, 4)
eval_survival(d, at = 0:4)
enframe_survival(d, at = 0:4)
}
\seealso{
Other distributional representations: 
\code{\link{eval_cdf}()},
\code{\link{eval_chf}()},
\code{\link{eval_density}()},
\code{\link{eval_hazard}()},
\code{\link{eval_odds}()},
\code{\link{eval_pmf}()},
\code{\link{eval_quantile}()},
\code{\link{eval_return}()}
}
\concept{distributional representations}
