% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_property.R
\name{eval_property}
\alias{eval_property}
\title{Evaluate a distribution}
\usage{
eval_property(distribution, entry, ...)
}
\arguments{
\item{distribution}{Distribution object.}

\item{entry}{Name of the property, such as "cdf" or
"mean". Length 1 character vector.}

\item{...}{If the property is a function, arguments to the
function go here. Need not be named; inserted in the order they
appear.}
}
\value{
The distribution's property, evaluated. If cannot be
evaluated, returns \code{NULL}.
}
\description{
Evaluate a distribution property. The distribution itself
is first searched for the property, and if it can't
be found, will attempt to calculate the property
from other entries.
}
\examples{
d <- distribution(
  cdf = function(x) {
    (x > 0) * pmin(x^2, 1)
  },
  g = 9.81,
  .vtype = "continuous"
)
eval_property(d, "g")
eval_property(d, "quantile", 1:9 / 10)
eval_property(d, "mean")
eval_property(d, "realise", 10)
eval_property(d, "foofy")
eval_property(d, "foofy", 1:10)
}
