% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theil.wtd.R
\name{theil.wtd}
\alias{theil.wtd}
\title{Theil index}
\source{
Plat, D. (2012). IC2: Inequality and Concentration Indices and Curves. R package
version 1.0-1. https://CRAN.R-project.org/package=IC2
}
\usage{
theil.wtd(x, weights = NULL)
}
\arguments{
\item{x}{a numeric vector containing at least non-negative elements.}

\item{weights}{an optional vector of weights of x to be used in the computation of the Theil
index. Should be NULL or a numeric vector.}
}
\value{
The value of the Theil index.
}
\description{
Returns the (optional weighted) Theil index for a vector.
}
\details{
The Theil index is a measure of inequality among values of a distribution. It is a
member of the Generalized Entropy Measures. Also referred to as GE(1). The index can have a value between 0 and ln N
(the logarithm of the number of values), with 0 being the lowest possible inequality. It uses
a logarithmic transformation of the values of the distribution. Therefore it cannot
handle negative or zero values. Those are excluded from the computation in this function. The
Theil Index is more sensitive for changes in the upper tail of the distribution.

Extension of the calcGEI function in IC2 package in order to handle missings.
}
\examples{
#calculate Theil Index using Mexican Income data set
data(mex_inc_2008)

#unweighted Theil Index:
theil.wtd(mex_inc_2008$income)

#weighted Theil Index:
theil.wtd(x=mex_inc_2008$income, weights=mex_inc_2008$factor)

}
\references{
Haughton, J. and S. Khandker. (2009) \emph{Handbook on poverty and inequality},
Washington, DC: World Bank.

Cowell F. (2000) Measurement of Inequality. In Atkinson A. and Bourguignon F. (eds.) \emph{
Handbook of Income Distribution}. Amsterdam: Elsevier, p. 87-166.
}
