% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monte_carlo.R
\name{estimate_mc_time}
\alias{estimate_mc_time}
\title{Estimates Execution Time for Monte Carlo Simulations}
\usage{
estimate_mc_time(tree, num_runs, num_test = 50)
}
\arguments{
\item{tree}{A \code{Tree} object for simulations.}

\item{num_runs}{A \code{Numeric}, total number of simulations desired.}

\item{num_test}{A \code{Numeric}, number of test simulations for time
estimation (default is 50).}
}
\value{
A \code{character} string with estimated execution time (in minutes)
}
\description{
Estimates the time required to run a set number of Monte Carlo simulations
based on the time taken to run a smaller test set.
}
\examples{
tree <- dexisensitivity::masc2
estimate_mc_time(tree, num_runs = 1000, num_test = 50)

}
