% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descsuppR-package.r
\name{convertColumnHeading}
\alias{convertColumnHeading}
\title{Convert Grouping Column Values into Headings with ddply}
\usage{
convertColumnHeading(df, col, movealong = NULL)
}
\arguments{
\item{df}{A data frame to be processed.}

\item{col}{Character. Name of the column in \code{df} to use for grouping and converting to headings.}

\item{movealong}{Optional character vector of column names. For each group, these columns are rotated, placing their first value after the last row.}
}
\value{
A data frame formatted with expanded headings per group.
}
\description{
For each unique value in the specified column of a data frame, creates a "subtable" where that value is moved as a group heading (first row) and the column is blanked for the remaining rows.
Optionally, can "move along" specified metadata columns, shifting their first element to the last row.
}
\details{
The function uses \code{plyr::ddply} to split the data frame by the levels of \code{col}. For each group,
  - Moves the grouping value to a heading (top row)
  - Adds an empty row for formatting
  - Optionally rotates metadata columns specified in \code{movealong}
This can be useful for preparing tables for presentation or reporting.
}
\examples{
df <- data.frame(Group = c("A", "A", "B", "B"), Data = 1:4, Meta = c("x", "y", "z", "w"))
convertColumnHeading(df, "Group")
convertColumnHeading(df, "Group", movealong = "Meta")
}
\author{
Andreas Leha
}
