% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_bnb.r
\name{mle_bnb}
\alias{mle_bnb}
\alias{mle_bnb_null}
\alias{mle_bnb_alt}
\title{MLE for BNB}
\usage{
mle_bnb_null(data, ratio_null = 1, method = "nlm_constrained", ...)

mle_bnb_alt(data, method = "nlm_constrained", ...)
}
\arguments{
\item{data}{(list)\cr
A list whose first element is the vector of negative binomial values
from sample 1 and the second element is the vector of negative
binomial values from sample 2.
Each vector must be sorted by the subject/item index and must be the
same sample size. \link[base]{NA}s are silently excluded. The default
output from \code{\link[=sim_bnb]{sim_bnb()}}.}

\item{ratio_null}{(Scalar numeric: \code{1}; \verb{(0, Inf)})\cr
The ratio of means assumed under the null hypothesis (sample 2 / sample 1).
Typically \code{ratio_null = 1} (no difference).}

\item{method}{(string: \code{"nlm_constrained"})\cr
The optimization method. Must choose one of \code{"nlm"},
\code{"nlm_constrained"}, \code{"optim"}, or \code{"optim_constrained"}. The default
bounds for constrained optimization are \verb{[1e-03, 1e06]}.}

\item{...}{Optional arguments passed to the optimization method.}
}
\value{
\itemize{
\item For \code{mle_bnb_alt}, a list with the following elements:
\tabular{lll}{
Slot \tab Name \tab Description \cr
1 \tab \code{mean1} \tab MLE for mean of sample 1. \cr
2 \tab \code{mean2} \tab MLE for mean of sample 2. \cr
3 \tab \code{ratio} \tab MLE for ratio of means. \cr
4 \tab \code{dispersion} \tab MLE for BNB dispersion. \cr
5 \tab \code{nll} \tab Minimum of negative log-likelihood. \cr
6 \tab \code{nparams} \tab Number of estimated parameters. \cr
7 \tab \code{n1} \tab Sample size of sample 1. \cr
8 \tab \code{n2} \tab Sample size of sample 2. \cr
9 \tab \code{method} \tab Method used for the results. \cr
10 \tab \code{mle_method} \tab Method used for optimization. \cr
11 \tab \code{mle_code} \tab Integer indicating why the optimization process terminated. \cr
12 \tab \code{mle_message} \tab Additional information from the optimizer.
}
\item For \code{mle_bnb_null}, a list with the following elements:
\tabular{lll}{
Slot \tab Name \tab Description \cr
1 \tab \code{mean1} \tab MLE for mean of sample 1. \cr
2 \tab \code{mean2} \tab MLE for mean of sample 2. \cr
3 \tab \code{ratio_null} \tab Population ratio of means assumed for null hypothesis.
\code{mean2 = mean1 * ratio_null}. \cr
4 \tab \code{dispersion} \tab MLE for BNB dispersion. \cr
5 \tab \code{nll} \tab Minimum of negative log-likelihood. \cr
6 \tab \code{nparams} \tab Number of estimated parameters. \cr
7 \tab \code{n1} \tab Sample size of sample 1. \cr
8 \tab \code{n2} \tab Sample size of sample 2. \cr
9 \tab \code{method} \tab Method used for the results. \cr
10 \tab \code{mle_method} \tab Method used for optimization. \cr
11 \tab \code{mle_code} \tab Integer indicating why the optimization process terminated. \cr
12 \tab \code{mle_message} \tab Additional information from the optimizer.
}
}
}
\description{
Maximum likelihood estimates (MLE) for bivariate negative binomial outcomes.
}
\details{
These functions are primarily designed for speed in simulation. Missing values
are silently excluded.

Suppose \eqn{X_1 \mid G = g \sim \text{Poisson}(\mu g)} and
\eqn{X_2 \mid G = g \sim \text{Poisson}(r \mu g)} where
\eqn{G \sim \text{Gamma}(\theta, \theta^{-1})} is the random item (subject) effect.
Then \eqn{X_1, X_2 \sim \text{BNB}(\mu, r, \theta)} is the joint distribution where
\eqn{X_1} and \eqn{X_2} are dependent (though conditionally independent),
\eqn{X_1} is the count outcome for sample 1 of the items (subjects),
\eqn{X_2} is the count outcome for sample 2 of the items (subjects),
\eqn{\mu} is the conditional mean of sample 1, \eqn{r} is the ratio of the
conditional means of sample 2 with respect to sample 1, and \eqn{\theta} is
the gamma distribution shape parameter which controls the dispersion and the
correlation between sample 1 and 2.

The MLEs of \eqn{r} and \eqn{\mu} are \eqn{\hat{r} = \frac{\bar{x}_2}{\bar{x}_1}}
and \eqn{\hat{\mu} = \bar{x}_1}. The MLE of \eqn{\theta} is found by
maximizing the profile log-likelihood
\eqn{l(\hat{r}, \hat{\mu}, \theta)} with respect to \eqn{\theta}. When
\eqn{r = r_{null}} is known, the MLE of \eqn{\mu} is
\eqn{\tilde{\mu} = \frac{\bar{x}_1 + \bar{x}_2}{1 + r_{null}}} and
\eqn{\tilde{\theta}} is obtained by maximizing the profile log-likelihood
\eqn{l(r_{null}, \tilde{\mu}, \theta)} with respect to \eqn{\theta}.

The backend method for numerical optimization is controlled by argument
\code{method} which refers to \code{\link[stats:nlm]{stats::nlm()}}, \code{\link[stats:nlminb]{stats::nlminb()}}, or
\code{\link[stats:optim]{stats::optim()}}. If you would like to see warnings from the optimizer,
include argument \code{warnings = TRUE}.
}
\examples{
#----------------------------------------------------------------------------
# mle_bnb() examples
#----------------------------------------------------------------------------
library(depower)

set.seed(1234)
d <- sim_bnb(
  n = 40,
  mean1 = 10,
  ratio = 1.2,
  dispersion = 2
)

mle_alt <- d |>
  mle_bnb_alt()

mle_null <- d |>
  mle_bnb_null()

mle_alt
mle_null

}
\references{
\insertRef{rettiganti_2012}{depower}

\insertRef{aban_2009}{depower}
}
\seealso{
\code{\link[=sim_bnb]{sim_bnb()}}, \link{nll_bnb}
}
