% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaccd_plot.R
\name{plotRefHeatmap}
\alias{plotRefHeatmap}
\title{Visualize the reference pattern of gene co-expression.}
\usage{
plotRefHeatmap(refCor)
}
\arguments{
\item{refCor}{Correlation matrix, such as comes from \code{\link[=getRefCor]{getRefCor()}}.}
}
\value{
A \code{ggplot} object, which can be saved using \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.
Heatmap colors will be directly comparable to any heatmaps created by this
function or by \code{\link[=plotHeatmap]{plotHeatmap()}}.
}
\description{
Make a heatmap of the reference correlation matrix for gene co-expression.
}
\examples{
refCor = getRefCor()
pRef = plotRefHeatmap(refCor)
pTest = plotHeatmap(rownames(refCor), GSE19188$emat, GSE19188$groupVec)

}
\seealso{
\code{\link[=getRefCor]{getRefCor()}}, \code{\link[=plotHeatmap]{plotHeatmap()}}
}
