% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_degross_plot.R
\name{plot.degross}
\alias{plot.degross}
\title{Plot the density estimate obtained from grouped summary statistics using \link{degross} and superpose it to the observed histogram.}
\usage{
\method{plot}{degross}(x, col="black", lwd=2, lty="dashed", xlab="", ylab="Density", main="",...)
}
\arguments{
\item{x}{A \link{degross.object} generated by \link{degross}.}

\item{col}{Color used for plotting the fitted density.}

\item{lwd}{Line width for the fitted density curve.}

\item{lty}{Line type for the the fitted density curve.}

\item{xlab}{Label on the x-axis.}

\item{ylab}{Label on the y-axis.}

\item{main}{Title for the generated graph.}

\item{...}{Further arguments to be passed to \code{hist}.}
}
\value{
A histogram based on the observed big bin frequencies with the fitted density superposed.
}
\description{
Plot the density estimate corresponding to a \code{degross} object and superpose it to the observed histogram.
}
\examples{
sim = simDegrossData(n=3500, plotting=TRUE,choice=2) ## Generate grouped data
obj.data = degrossData(Big.bins=sim$Big.bins, freq.j=sim$freq.j, m.j=sim$m.j)
print(obj.data)
obj.fit = degross(obj.data) ## Estimate the underlying density
plot(obj.fit) ## Plot the fitted density with the data histogram

}
\references{
Lambert, P. (2021) Moment-based density and risk estimation from grouped summary statistics. arXiv:2107.03883.
}
\seealso{
\code{\link{degross}}, \code{\link{degross.object}}, \code{\link{print.degross}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
