% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degross_lpostBasic.R
\name{degross_lpostBasic}
\alias{degross_lpostBasic}
\title{Log-posterior for given spline parameters, big bin (and optional: small bin) frequencies, tabulated sample moments and roughness penalty parameter.
Compared to \link{degross_lpost}, no Fisher information matrix is computed and the gradient evaluation is optional, with a resulting computational gain.}
\usage{
degross_lpostBasic(phi, tau, n.i, degross.data,
                          use.moments = rep(TRUE,4), freq.min = 20, diag.only=FALSE,
                          gradient=FALSE,
                          penalize = TRUE, aa = 2, bb = 1e-6, pen.order = 3)
}
\arguments{
\item{phi}{Vector of K B-spline parameters \eqn{\phi} to specify the log-density.}

\item{tau}{Roughness penalty parameter.}

\item{n.i}{Small bin frequencies.}

\item{degross.data}{A \link{degrossData.object} created using the \link{degrossData} function.}

\item{use.moments}{Vector with 4 logicals indicating which tabulated sample moments to use as soft constraints. Defaults: \code{rep(TRUE,4)}.}

\item{freq.min}{Minimal big bin frequency required to use the corresponding observed moments as soft constraints. Default: \code{20}.}

\item{diag.only}{Logical indicating whether to ignore the off-diagonal elements of the variance-covariance matrix of the sample central moments. Default: FALSE.}

\item{gradient}{Logical indicating if the gradient (Score) of the \eqn{\log p(\phi|\tau,data)} should be computed (default: FALSE).}

\item{penalize}{Logical indicating whether a roughness penalty of order \code{pen.order} is required (with \eqn{tau \sim G(aa,bb)}). Default: \code{TRUE}.}

\item{aa}{Real giving the first parameter in the Gamma prior for \code{tau}. Default: \code{2}.}

\item{bb}{Real giving the second parameter in the Gamma prior for \code{tau}. Default: \code{1e-6}.}

\item{pen.order}{Integer giving the order of the roughness penalty. Default: \code{3}.}
}
\value{
A list containing :
\itemize{
\item{\code{lpost.ni} : \verb{ }}{value of the log-posterior based on the given small bin frequencies \code{n.i} and the tabulated sample moments.}
\item{\code{lpost.mj} : \verb{ }}{value of the log-posterior based on the big bin frequencies \code{degross.data$freq.j} and the tabulated sample moments.}
\item{\code{llik.ni} : \verb{ }}{multinomial log-likelihood based on the given small bin frequencies \code{n.i}.}
\item{\code{llik.mj} : \verb{ }}{multinomial log-likelihood based on the big bin frequencies \code{degross.data$freq.j} resulting from \code{n.i}.}
\item{\code{moments.penalty} : \verb{ }}{log of the joint (asymptotic) density for the observed sample moments.}
\item{\code{penalty} : \verb{ }}{\eqn{\log p(\phi|\tau) + \log p(\tau)}.}
\item{\code{M.j} : \verb{ }}{theoretical moments of the density (resulting from \eqn{\phi}) within a big bin.}
\item{\code{pi.i} : \verb{ }}{small bin probabilities.}
\item{\code{ui} : \verb{ }}{small bin midpoints.}
\item{\code{delta} : \verb{ }}{width of the small bins.}
\item{\code{gamma.j} : \verb{ }}{big bin probabilities.}
\item{\code{tau} : \verb{ }}{reminder of the value of the roughness penalty parameter \eqn{\tau}.}
\item{\code{phi} : \verb{ }}{reminder of the vector of spline parameters (defining the density).}
\item{\code{n.i} : \verb{ }}{reminder of the small bin frequencies given as input.}
\item{\code{freq.j} : \verb{ }}{reminder of the big bin frequencies in \code{degross.data$freq.j}.}
}
}
\description{
Log-posterior for given spline parameters, big bin (and optional: small bin) frequencies, tabulated sample moments and roughness penalty parameter.
Compared to \link{degross_lpost}, no Fisher information matrix is computed and the gradient evaluation is optional, with a resulting computational gain.
}
\examples{
sim = simDegrossData(n=3500, plotting=TRUE,choice=2) ## Generate grouped data
obj.data = degrossData(Big.bins=sim$Big.bins, freq.j=sim$freq.j, m.j=sim$m.j)
print(obj.data)
obj.fit = degross(obj.data) ## Estimate the underlying density
phi.hat = obj.fit$phi ; tau.hat = obj.fit$tau
## Evaluate the log-posterior at convergence
res = degross_lpostBasic(phi=phi.hat, tau=tau.hat, degross.data=obj.data,
                         gradient=TRUE)
print(res)

}
\references{
Lambert, P. (2021) Moment-based density and risk estimation from grouped summary statistics. arXiv:2107.03883.
}
\seealso{
\code{\link{degross_lpost}}, \code{\link{degross}}, \code{\link{degross.object}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
