% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_deduped.R
\name{with_deduped}
\alias{with_deduped}
\title{Deduplicate the first argument in an expression}
\usage{
with_deduped(expr, env = parent.frame())
}
\arguments{
\item{expr}{The expression to evaluate.}

\item{env}{The environment within which to evaluate the expression. Can be
modified when calling inside other functions.}
}
\value{
The result of evaluating the expression.
}
\description{
This is a convenience wrapper for \code{deduped()} to allow it to be piped into
an expression. It will recursively parse the first arguments of the
expression call tree to find the bottom -- when the first argument is not
itself a function call.
\itemize{
\item Without nesting: \code{f(x, ...) |> with_deduped()} is equivalent to
\verb{deduped(\\(.z) f(.z, ...))(x)}.
\item With nesting: \code{f(g(x, g2), f2) |> with_deduped()} is equivalent to
\verb{deduped(\\(.z) f(g(.z, g2), f2))(x)}.
}
}
\examples{

x <- sample(LETTERS, 10)
x

large_x <- sample(rep(x, 10))
length(large_x)

slow_func <- function(x) {
  for (i in x) {
    Sys.sleep(0.001)
  }
  tolower(x)
}

system.time({
  y1 <- slow_func(large_x)
})


system.time({
  y2 <- with_deduped(slow_func(large_x))

  # Can also use the R pipe (R >= 4.1.0) or magrittr pipe, for convenience.
  # slow_func(large_x) |> with_deduped()
})

all(y1 == y2)
}
