% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casting.R
\name{cast-tetra}
\alias{cast-tetra}
\alias{deb_as_tetra}
\alias{deb_as_tetra.default}
\alias{deb_as_tetra.deb_tetra}
\alias{deb_as_tetra.deb_lsd}
\alias{deb_as_tetra.deb_decimal}
\alias{deb_as_tetra.numeric}
\alias{deb_as_tetra.logical}
\alias{deb_as_tetra.list}
\title{Cast to \code{deb_tetra}}
\usage{
deb_as_tetra(x, ...)

\method{deb_as_tetra}{default}(x, ...)

\method{deb_as_tetra}{deb_tetra}(x, ...)

\method{deb_as_tetra}{deb_lsd}(x, f, ...)

\method{deb_as_tetra}{deb_decimal}(x, f, ...)

\method{deb_as_tetra}{numeric}(x, bases = c(20, 12, 4), ...)

\method{deb_as_tetra}{logical}(x, bases = c(20, 12, 4), ...)

\method{deb_as_tetra}{list}(x, bases = c(20, 12, 4), ...)
}
\arguments{
\item{x}{An object to coerce to \code{deb_tetra}.}

\item{...}{Arguments passed on to further methods.}

\item{f}{Integer of length 1 to represent the base of the farthing unit.
Must be provided to cast from deb_lsd or deb_decimal vectors with
tripartite bases to deb_tetra.}

\item{bases}{Numeric vector of length 3 used to specify the bases for the
solidus or s, denarius or d, and farthing or f units. Default is
\code{c(20, 12, 4)}, which conforms to the English system of 1 pound =
20 shillings, 1 shilling = 12 pence, and 1 pence = 4 farthing.}
}
\value{
A \code{deb_tetra} vector.
}
\description{
Cast \code{x} to a \code{deb_tetra} vector.
}
\details{
Casting a list of numeric vectors of length 4 to \code{deb_tetra}
provides an alternate way to create a \code{deb_tetra} vector than
\code{\link[=deb_tetra]{deb_tetra()}}. This method may be helpful because the data is input
by the value instead of by the unit.
}
\examples{

# To cast from deb_lsd to deb_tetra an "f" unit must be supplied

# Compare
lsd1 <- deb_lsd(8, 12, 4)
lsd2 <- deb_lsd(8, 12, 4, bases = c(60, 16))

deb_as_tetra(lsd1, f = 4)
deb_as_tetra(lsd2, f = 8)

# Cast a deb_decimal vector with four units to deb_tetra.
# Bases are automatically applied when casting from
# tetrapartite deb_decimal to deb_tetra.
x <- c(5.11875, 3.76875, 25/3)
d1 <- deb_decimal(x, bases = c(20, 12, 4))
deb_as_tetra(d1)

# Use "f" argument to cast from tripartite deb_decimal
# to deb_tetra
d2 <- deb_decimal(x)
deb_as_tetra(d2, f = 4)

# Cast a numeric vector to deb_tetra
deb_as_tetra(x)

# Use the bases argument to apply non-default bases
deb_as_tetra(x, bases = c(60, 16, 8))

# Casting a list to deb_tetra provides an alternate
# to deb_tetra(). This can be helpful for legibility.
# Compare:

deb_as_tetra(
  list(c(5, 12, 3, 2),
       c(13, 8, 11, 1),
       c(7, 16, 0, 3))
  )

deb_tetra(l = c(5, 13, 7),
          s = c(12, 8, 16),
          d = c(3, 11, 0),
          f = c(2, 1, 3))

}
\seealso{
\code{\link[=deb_as_lsd]{deb_as_lsd()}} and \code{\link[=deb_as_decimal]{deb_as_decimal()}}
}
