% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propensity_score_methods.R
\name{estEffect_matching}
\alias{estEffect_matching}
\alias{estEffect_stratification}
\alias{estEffect_weighting}
\title{Estimate Treatment Effects using Propensity Score Matching}
\usage{
estEffect_matching(form, data, yvars, ncovars, distance, outcome_measure)

estEffect_stratification(form, data, yvars, ncovars, distance, outcome_measure)

estEffect_weighting(form, data, yvars, ncovars, distance, outcome_measure)
}
\arguments{
\item{form}{A formula specifying the treatment assignment model.}

\item{data}{A dataset containing covariates and treatment assignment.}

\item{yvars}{A character vector of outcome variable names.}

\item{ncovars}{A character vector of negative control outcome variable names.}

\item{distance}{The method for estimating propensity scores ("glm").}

\item{outcome_measure}{The outcome measure to estimate: "RR" (Risk Ratio), "OR" (Odds Ratio), or "HR" (Hazard Ratio).}
}
\value{
List of components

List of components

List of components
}
\description{
Computes effect estimates using propensity score matching to reduce confounding.

Computes effect estimates using propensity score stratification to adjust for confounding.

Computes effect estimates using propensity score weighting to balance covariates between treatment groups.
}
