% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_TTE.R
\name{calibrate_TTE}
\alias{calibrate_TTE}
\title{Negative Control Calibration for Target Trial Emulation}
\usage{
calibrate_TTE(tte_obj = NULL, custom_results = NULL, custom_nco_results = NULL)
}
\arguments{
\item{tte_obj}{Optional. An object of class "TTE" from the TTE_pipeline function. If provided, the function
will use the negative control results from this object. Either this or both custom_results
and custom_nco_results must be provided.}

\item{custom_results}{Optional. A data frame containing the primary outcome results if no TTE object is available.
Must contain columns 'names_outcome', 'logEst', and 'seLogEst'.}

\item{custom_nco_results}{Optional. A data frame containing the negative control outcome results if no TTE object is available.
Must contain columns 'names_outcome', 'logEst', and 'seLogEst'.}
}
\value{
An object of class "dTTE" containing both the TTE results and calibration results
}
\description{
Performs calibration with negative control outcomes to further reduce confounding bias in
Target Trial Emulation results.
}
\examples{
library("dplyr")
data(demo_data)
# First run TTE pipeline
xvars <- c("eth_cat", "age_cat", "sex", "cohort_entry_month",
            "obese", "pmca_index", "n_ed", "n_inpatient",
           "n_tests", "imm_date_diff_grp", "medical_1", "medical_2",
           "medical_3", "medical_4", "medical_5")
yvars1 <- colnames(demo_data \%>\% select(starts_with("visits_")))
ncovars1 <- colnames(demo_data \%>\% select(starts_with("nco_visits_")))
tte_result <- TTE_pipeline(demo_data, xvars=xvars, yvars=yvars1, ncovars=ncovars1,
                         ps_type="Matching", outcome_measure="RR")

# Then calibrate results
dtte_result <- calibrate_TTE(tte_obj = tte_result)

# Alternatively, provide custom results
df_results <- data.frame(
  names_outcome = c("outcome1", "outcome2"),
  logEst = c(0.1, -0.2),
  seLogEst = c(0.05, 0.08)
)
df_nco_results <- data.frame(
  names_outcome = c("nco1", "nco2", "nco3"),
  logEst = c(0.02, -0.03, 0.01),
  seLogEst = c(0.03, 0.04, 0.02)
)
dtte_result <- calibrate_TTE(custom_results = df_results, custom_nco_results = df_nco_results)
}
