% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_search.R
\name{dictionary_search}
\alias{dictionary_search}
\title{Data Dictionary Search}
\usage{
dictionary_search(
  DD.dict,
  search.term = c("blood pressure"),
  search.column = c("VARDESC")
)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{search.term}{Search term.}

\item{search.column}{Column of the data dictionary to search.}
}
\value{
Tibble containing dictionary rows in which the search term was detected in specified column or an error message if the search column could not be detected.
}
\description{
This awareness function helps you search the data dictionary for a specific term; intended for use as an investigative aid to supplement other checks in this package.
}
\examples{
# Successful search
data(ExampleB)
dictionary_search(DD.dict.B, search.term=c("skinfold"), search.column=c("VARDESC"))
# Attempted search in wrong column
dictionary_search(DD.dict.B, search.term=c("skinfold"), search.column=c("VARIABLE_DESCRIPTION"))
}
