% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_report.R
\name{check_report}
\alias{check_report}
\title{Check Report}
\usage{
check_report(DD.dict, DS.data, non.NA.missing.codes = NA, compact = TRUE)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{non.NA.missing.codes}{A user-defined vector of numerical missing value codes (e.g., -9999).}

\item{compact}{When TRUE, the function prints a compact report, listing information from only the non-passed checks.}
}
\value{
Tibble, returned invisibly, containing the following information for each check: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (More detailed information about the potential errors identified).
}
\description{
This function generates a user-readable report of the checks run by the complete_check function.
}
\examples{
# Example 1: Incorrectly showing as pass check on first attempt
data(ExampleB)
report <- check_report(DD.dict.B, DS.data.B)
# Addition of missing value codes calls attention to error
# at missing_value_check
report <- check_report(DD.dict.B, DS.data.B, non.NA.missing.codes=c(-4444, -9999))

# Example 2: Several fail checks or not attempted
data(ExampleC)
report <- check_report(DD.dict.C, DS.data.C, non.NA.missing.codes=c(-4444, -9999))
# Note you can also run report using compact=FALSE
report <- check_report(DD.dict.C, DS.data.C, non.NA.missing.codes=c(-4444, -9999), compact = FALSE)
}
\seealso{
\code{\link{complete_check}}
}
