% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProfileDifference.R
\name{ProfileDifference}
\alias{ProfileDifference}
\title{Profile Difference Calculation for Change Detection}
\description{
Implements the calculation of profile differences using various methods such as PDI, L2, and L2 derivative.
The class provides methods for setting profiles and calculating the differences.
}
\details{
The class supports multiple methods for calculating profile differences, including the Profile Disparity Index (PDI)
using gold or simple derivative methods, and L2 norm and L2 derivative calculations. It allows for customization
of various parameters such as embedding dimensions, derivative orders, and thresholds.
}
\examples{
set.seed(123)  # Setting a seed for reproducibility
profile1 <- list(x = 1:100, y = sin(1:100))
profile2 <- list(x = 1:100, y = sin(1:100) + rnorm(100, 0, 0.1))
pd <- ProfileDifference$new(method = "pdi", deriv = "gold")
pd$set_profiles(profile1, profile2)
result <- pd$calculate_difference()
message(result)
}
\references{
Kobylińska, K., Krzyziński, M., Machowicz, R., Adamek, M., & Biecek, P. (2023). Exploration of the Rashomon Set Assists Trustworthy Explanations for Medical Data. arXiv e-prints, arXiv-2308.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{method}}{The method used for profile difference calculation.}

\item{\code{deriv}}{The method used for derivative calculation.}

\item{\code{gold_spline}}{Boolean indicating if cubic spline should be used in gold method.}

\item{\code{gold_embedding}}{Embedding dimension for gold method.}

\item{\code{nderiv}}{Order of the derivative for simple method.}

\item{\code{gold_spline_threshold}}{Threshold for cubic spline in gold method.}

\item{\code{epsilon}}{Small value to avoid numerical issues.}

\item{\code{profile1}}{The first profile.}

\item{\code{profile2}}{The second profile.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ProfileDifference-new}{\code{ProfileDifference$new()}}
\item \href{#method-ProfileDifference-reset}{\code{ProfileDifference$reset()}}
\item \href{#method-ProfileDifference-set_profiles}{\code{ProfileDifference$set_profiles()}}
\item \href{#method-ProfileDifference-calculate_difference}{\code{ProfileDifference$calculate_difference()}}
\item \href{#method-ProfileDifference-clone}{\code{ProfileDifference$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProfileDifference-new"></a>}}
\if{latex}{\out{\hypertarget{method-ProfileDifference-new}{}}}
\subsection{Method \code{new()}}{
Initializes the ProfileDifference class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProfileDifference$new(
  method = "pdi",
  deriv = "gold",
  gold_spline = TRUE,
  gold_embedding = 4,
  nderiv = 4,
  gold_spline_threshold = 0.01,
  epsilon = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{The method used for profile difference calculation.}

\item{\code{deriv}}{The method used for derivative calculation.}

\item{\code{gold_spline}}{Boolean indicating if cubic spline should be used in gold method.}

\item{\code{gold_embedding}}{Embedding dimension for gold method.}

\item{\code{nderiv}}{Order of the derivative for simple method.}

\item{\code{gold_spline_threshold}}{Threshold for cubic spline in gold method.}

\item{\code{epsilon}}{Small value to avoid numerical issues.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProfileDifference-reset"></a>}}
\if{latex}{\out{\hypertarget{method-ProfileDifference-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the internal state of the detector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProfileDifference$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProfileDifference-set_profiles"></a>}}
\if{latex}{\out{\hypertarget{method-ProfileDifference-set_profiles}{}}}
\subsection{Method \code{set_profiles()}}{
Sets the profiles for comparison.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProfileDifference$set_profiles(profile1, profile2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{profile1}}{The first profile.}

\item{\code{profile2}}{The second profile.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProfileDifference-calculate_difference"></a>}}
\if{latex}{\out{\hypertarget{method-ProfileDifference-calculate_difference}{}}}
\subsection{Method \code{calculate_difference()}}{
Calculates the difference between the profiles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProfileDifference$calculate_difference()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing the method details and the calculated distance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProfileDifference-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ProfileDifference-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProfileDifference$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
