% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_cal.R
\name{pivot_percent_at_multi}
\alias{pivot_percent_at_multi}
\title{Create an aggragated data table with all proportion of multiple selected column}
\usage{
pivot_percent_at_multi(dt, question_col, aggregated_by_cols)
}
\arguments{
\item{dt}{data table}

\item{question_col}{columns selected as questions}

\item{aggregated_by_cols}{grouped by columns}
}
\value{
an aggragated data table
}
\description{
Create an aggragated data table with all proportion of multiple selected column
}
\examples{
test_dt <- data.table::data.table(
  Question1 = c(rep("Good", 3), rep("OK", 3), rep("Bad", 3)),
  Question2 = c(rep("Good", 2), rep("OK", 2), rep("Bad", 5)),
  Gender = c(rep("F", 4), rep("M", 5))
)
dataMojo::pivot_percent_at_multi(test_dt,
  question_col = c("Question1","Question2") , aggregated_by_cols = "Gender")
}
