% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.dart2genlight.r
\name{utils.dart2genlight}
\alias{utils.dart2genlight}
\title{An internal function to converts DarT to genlight.}
\usage{
utils.dart2genlight(
  dart,
  ind.metafile = NULL,
  covfilename = NULL,
  probar = TRUE,
  verbose = NULL
)
}
\arguments{
\item{dart}{A dart object created via read.dart [required].}

\item{ind.metafile}{Optional file in csv format with metadata for each
individual (see details for explanation) [default NULL].}

\item{covfilename}{Depreciated, use parameter ind.metafile.}

\item{probar}{Show progress bar [default TRUE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report [default NULL].}
}
\value{
A genlight object. Including all available slots are filled.
loc.names, ind.names, pop, lat, lon (if provided via the ind.metadata file)
}
\description{
WARNING: UTILITY SCRIPTS ARE FOR INTERNAL USE ONLY AND SHOULD NOT BE USED BY END USERS AS THEIR USE OUT OF CONTEXT COULD LEAD TO UNPREDICTABLE OUTCOMES.
}
\details{
Converts a DArT file (read via \code{read.dart}) into an
genlight object from package adegenet. #' Internal function called by gl.read.dart().

The ind.metadata file needs to have very specific headings. First a heading
called id. Here the ids have to match the ids in the dart object
\code{colnames(dart[[4]])}. The following column headings are optional.
pop: specifies the population membership of each individual. lat and lon
specify spatial coordinates (in decimal degrees WGS1984 format). Additional
columns with individual metadata can be imported (e.g. age, gender).
}
\seealso{
Other utilities: 
\code{\link{gl.alf}()},
\code{\link{utils.check.datatype}()},
\code{\link{utils.collapse.matrix}()},
\code{\link{utils.dist.binary}()},
\code{\link{utils.flag.start}()},
\code{\link{utils.hamming}()},
\code{\link{utils.het.pop}()},
\code{\link{utils.impute}},
\code{\link{utils.is.fixed}()},
\code{\link{utils.jackknife}()},
\code{\link{utils.n.var.invariant}()},
\code{\link{utils.plot.save}()},
\code{\link{utils.read.fasta}()},
\code{\link{utils.read.ped}()},
\code{\link{utils.recalc.avgpic}()},
\code{\link{utils.recalc.callrate}()},
\code{\link{utils.recalc.freqhets}()},
\code{\link{utils.recalc.freqhomref}()},
\code{\link{utils.recalc.freqhomsnp}()},
\code{\link{utils.recalc.maf}()},
\code{\link{utils.reset.flags}()},
\code{\link{utils.transpose}()},
\code{\link{utils.vcfr2genlight.polyploid}()}
}
\author{
Maintainer: Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{utilities}
