% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_knn.R
\name{reg_knn}
\alias{reg_knn}
\title{K-Nearest Neighbors (KNN) Regression}
\usage{
reg_knn(attribute, k)
}
\arguments{
\item{attribute}{attribute target to model building}

\item{k}{number of k neighbors}
}
\value{
returns a knn regression object
}
\description{
KNN regression using \code{FNN::knn.reg}, predicting by averaging the targets of the k nearest neighbors.
}
\details{
Non‑parametric approach suitable for local smoothing. Sensitive to feature scaling; consider normalization beforehand.
}
\examples{
data(Boston)
model <- reg_knn("medv", k=3)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, Boston)
train <- sr$train
test <- sr$test

model <- fit(model, train)

test_prediction <- predict(model, test)
test_predictand <- test[,"medv"]
test_eval <- evaluate(model, test_predictand, test_prediction)
test_eval$metrics
}
\references{
Altman, N. (1992). An Introduction to Kernel and Nearest-Neighbor Nonparametric Regression.
}
